import React from 'react';
import { motion } from 'framer-motion';
import { Link } from 'react-router-dom';
import { COMPANY_NAME } from '../utils/constants/company-details';
import TeamMembersSection from '../components/about/TeamMembersSection';

const TeamDetails: React.FC = () => {
    return (
        <div className="min-h-screen bg-gray-900">
            {/* Hero Section */}
            <section className="relative py-20 bg-gradient-to-r from-blue-900 to-indigo-900">
                <div className="container px-4 mx-auto">
                    <div className="max-w-4xl mx-auto text-center">
                        <motion.h1 
                            className="mb-6 text-4xl font-bold text-white md:text-5xl lg:text-6xl"
                            initial={{ opacity: 0, y: 20 }}
                            animate={{ opacity: 1, y: 0 }}
                            transition={{ duration: 0.5 }}
                        >
                            Meet Our Team
                        </motion.h1>
                        <motion.p 
                            className="text-xl text-gray-300"
                            initial={{ opacity: 0, y: 20 }}
                            animate={{ opacity: 1, y: 0 }}
                            transition={{ duration: 0.5, delay: 0.2 }}
                        >
                            The talented individuals behind {COMPANY_NAME}'s success
                        </motion.p>
                    </div>
                </div>
            </section>

            {/* Team Members Section */}
            <section className="py-16 bg-gray-900">
                <div className="container px-4 mx-auto">
                    <TeamMembersSection />
                </div>
            </section>

            {/* CTA Section */}
            <section className="py-16 bg-indigo-900">
                <div className="container px-4 mx-auto text-center">
                    <h2 className="mb-6 text-3xl font-bold text-white">
                        Want to join our team?
                    </h2>
                    <p className="mb-8 text-xl text-gray-300">
                        We're always looking for talented individuals to join our growing team.
                    </p>
                    <Link
                        to="/contact"
                        className="inline-block px-8 py-3 text-lg font-medium text-white transition duration-300 bg-blue-600 rounded-lg hover:bg-blue-700"
                    >
                        Contact Us
                    </Link>
                </div>
            </section>
        </div>
    );
};

export default TeamDetails;
