import { motion } from "framer-motion";

const ServiceSEOSection = () => {
    return (
        <div id="seo" className="py-16 text-white bg-opacity-90 bg-gradient-to-r from-gray-900 to-gray-800">
            {/* Content Section */}
            <div className="relative z-10">
                <section className="relative px-6">
                    {/* Hero Section */}
                    <div className="max-w-5xl mx-auto text-center">
                        <motion.div
                            className="text-6xl"
                            initial={{ rotateY: 90, opacity: 0 }}
                            whileInView={{ rotateY: 0, opacity: 1 }}
                            transition={{ duration: 0.8 }}
                            viewport={{ once: true }}
                        >
                            🔍
                        </motion.div>
                        <motion.h2
                            className="mt-4 text-4xl font-bold"
                            initial={{ y: -20, opacity: 0 }}
                            whileInView={{ y: 0, opacity: 1 }}
                            transition={{ duration: 0.6, delay: 0.2 }}
                            viewport={{ once: true }}
                        >
                            Search Engine Optimization (SEO)
                        </motion.h2>
                        <motion.p
                            className="mt-4 text-lg text-gray-300"
                            initial={{ opacity: 0 }}
                            whileInView={{ opacity: 1 }}
                            transition={{ duration: 1, delay: 0.4 }}
                            viewport={{ once: true }}
                        >
                            Improve your online visibility and drive more organic traffic to your website with our comprehensive SEO services. We help businesses rank higher in search results and reach their target audience effectively.
                        </motion.p>
                    </div>

                    {/* Why Choose Us */}
                    <div className="max-w-5xl mx-auto mt-12">
                        <motion.h3
                            className="text-3xl font-bold text-center"
                            initial={{ opacity: 0 }}
                            whileInView={{ opacity: 1 }}
                            transition={{ duration: 0.5, delay: 0.2 }}
                            viewport={{ once: true }}
                        >
                            Our SEO Services
                        </motion.h3>

                        <div className="grid gap-8 mt-8 md:grid-cols-2 lg:grid-cols-3">
                            {[
                                {
                                    title: "Keyword Research",
                                    description: "Comprehensive keyword analysis to target the right audience and drive qualified traffic to your site.",
                                    icon: "🔍"
                                },
                                {
                                    title: "On-Page SEO",
                                    description: "Optimize your website's content, meta tags, and structure for better search engine visibility.",
                                    icon: "📄"
                                },
                                {
                                    title: "Technical SEO",
                                    description: "Improve your website's technical aspects including site speed, mobile-friendliness, and indexability.",
                                    icon: "⚙️"
                                },
                                {
                                    title: "Local SEO",
                                    description: "Enhance your local search presence and attract more customers from your area.",
                                    icon: "📍"
                                },
                                {
                                    title: "Content Strategy",
                                    description: "Develop a content plan that engages your audience and improves your search rankings.",
                                    icon: "✍️"
                                },
                                {
                                    title: "Link Building",
                                    description: "Build high-quality backlinks to improve your website's authority and search rankings.",
                                    icon: "🔗"
                                }
                            ].map((service, index) => (
                                <motion.div
                                    key={index}
                                    className="p-6 bg-gray-800 rounded-lg shadow-lg"
                                    initial={{ y: 20, opacity: 0 }}
                                    whileInView={{ y: 0, opacity: 1 }}
                                    transition={{ duration: 0.5, delay: 0.1 * index }}
                                    viewport={{ once: true }}
                                >
                                    <div className="text-4xl mb-4">{service.icon}</div>
                                    <h4 className="mb-2 text-xl font-semibold">{service.title}</h4>
                                    <p className="text-gray-300">{service.description}</p>
                                </motion.div>
                            ))}
                        </div>
                    </div>

                    {/* CTA Section */}
                    <motion.div 
                        className="mt-16 text-center"
                        initial={{ opacity: 0 }}
                        whileInView={{ opacity: 1 }}
                        transition={{ duration: 0.5, delay: 0.2 }}
                        viewport={{ once: true }}
                    >
                        <h3 className="mb-6 text-2xl font-bold">Ready to improve your search rankings?</h3>
                        <a
                            href="/contact"
                            className="inline-block px-8 py-3 text-lg font-semibold text-white transition-colors duration-300 bg-blue-600 rounded-lg hover:bg-blue-700"
                        >
                            Get Your Free SEO Audit
                        </a>
                    </motion.div>
                </section>
            </div>
        </div>
    );
};

export default ServiceSEOSection;
