import { motion } from "framer-motion";

const ServiceDigitalMarketingSection = () => {
    return (
        <div id="digital-marketing" className="py-16 text-white bg-opacity-90 bg-gradient-to-r from-blue-900 to-indigo-900">
            {/* Content Section */}
            <div className="relative z-10">
                <section className="relative px-6">
                    {/* Hero Section */}
                    <div className="max-w-5xl mx-auto text-center">
                        <motion.div
                            className="text-6xl"
                            initial={{ rotateY: 90, opacity: 0 }}
                            whileInView={{ rotateY: 0, opacity: 1 }}
                            transition={{ duration: 0.8 }}
                            viewport={{ once: true }}
                        >
                            📢
                        </motion.div>
                        <motion.h2
                            className="mt-4 text-4xl font-bold"
                            initial={{ y: -20, opacity: 0 }}
                            whileInView={{ y: 0, opacity: 1 }}
                            transition={{ duration: 0.6, delay: 0.2 }}
                            viewport={{ once: true }}
                        >
                            Digital Marketing
                        </motion.h2>
                        <motion.p
                            className="mt-4 text-lg text-gray-300"
                            initial={{ opacity: 0 }}
                            whileInView={{ opacity: 1 }}
                            transition={{ duration: 1, delay: 0.4 }}
                            viewport={{ once: true }}
                        >
                            Grow your online presence and reach your target audience with our comprehensive digital marketing services. We create data-driven strategies to boost your brand awareness and drive conversions.
                        </motion.p>
                    </div>

                    {/* Services */}
                    <div className="max-w-5xl mx-auto mt-12">
                        <motion.h3
                            className="text-3xl font-bold text-center"
                            initial={{ opacity: 0 }}
                            whileInView={{ opacity: 1 }}
                            transition={{ duration: 0.5, delay: 0.2 }}
                            viewport={{ once: true }}
                        >
                            Our Digital Marketing Services
                        </motion.h3>

                        <div className="grid gap-8 mt-8 md:grid-cols-2 lg:grid-cols-2">
                            {[
                                {
                                    title: "Social Media Marketing",
                                    description: "Engage with your audience and build brand loyalty through strategic social media campaigns across all major platforms.",
                                    icon: "📱"
                                },
                                {
                                    title: "Content Marketing",
                                    description: "Create valuable, relevant content that attracts and retains your target audience, driving profitable customer action.",
                                    icon: "✍️"
                                },
                                {
                                    title: "Email Marketing",
                                    description: "Nurture leads and build customer relationships through personalized email campaigns that convert.",
                                    icon: "📧"
                                },
                                {
                                    title: "PPC Advertising",
                                    description: "Reach your target audience with precision through paid search and display advertising campaigns.",
                                    icon: "🎯"
                                }
                            ].map((service, index) => (
                                <motion.div
                                    key={index}
                                    className="p-6 bg-white bg-opacity-10 rounded-lg backdrop-blur-sm"
                                    initial={{ y: 20, opacity: 0 }}
                                    whileInView={{ y: 0, opacity: 1 }}
                                    transition={{ duration: 0.5, delay: 0.1 * index }}
                                    viewport={{ once: true }}
                                >
                                    <div className="text-4xl mb-4">{service.icon}</div>
                                    <h4 className="mb-2 text-xl font-semibold">{service.title}</h4>
                                    <p className="text-gray-300">{service.description}</p>
                                </motion.div>
                            ))}
                        </div>
                    </div>

                    {/* Strategy Section */}
                    <div className="max-w-5xl mx-auto mt-16">
                        <motion.h3
                            className="mb-8 text-3xl font-bold text-center"
                            initial={{ opacity: 0 }}
                            whileInView={{ opacity: 1 }}
                            transition={{ duration: 0.5, delay: 0.2 }}
                            viewport={{ once: true }}
                        >
                            Our Digital Marketing Approach
                        </motion.h3>
                        
                        <div className="space-y-6">
                            {[
                                {
                                    title: "Data-Driven Strategies",
                                    description: "We base our decisions on data and analytics to ensure maximum ROI for your marketing campaigns."
                                },
                                {
                                    title: "Targeted Campaigns",
                                    description: "We create highly targeted campaigns that reach the right audience with the right message at the right time."
                                },
                                {
                                    title: "Continuous Optimization",
                                    description: "We constantly monitor and optimize campaigns to improve performance and achieve better results."
                                },
                                {
                                    title: "Transparent Reporting",
                                    description: "We provide detailed reports and insights to keep you informed about your campaign's performance."
                                }
                            ].map((item, index) => (
                                <motion.div
                                    key={index}
                                    className="p-6 bg-white bg-opacity-5 rounded-lg"
                                    initial={{ x: index % 2 === 0 ? -50 : 50, opacity: 0 }}
                                    whileInView={{ x: 0, opacity: 1 }}
                                    transition={{ duration: 0.5, delay: 0.1 * index }}
                                    viewport={{ once: true }}
                                >
                                    <h4 className="mb-2 text-xl font-semibold">{item.title}</h4>
                                    <p className="text-gray-300">{item.description}</p>
                                </motion.div>
                            ))}
                        </div>
                    </div>

                    {/* CTA Section */}
                    <motion.div 
                        className="mt-16 text-center"
                        initial={{ opacity: 0 }}
                        whileInView={{ opacity: 1 }}
                        transition={{ duration: 0.5, delay: 0.2 }}
                        viewport={{ once: true }}
                    >
                        <h3 className="mb-6 text-2xl font-bold">Ready to grow your business online?</h3>
                        <a
                            href="/contact"
                            className="inline-block px-8 py-3 text-lg font-semibold text-white transition-colors duration-300 bg-pink-600 rounded-lg hover:bg-pink-700"
                        >
                            Get Your Free Marketing Consultation
                        </a>
                    </motion.div>
                </section>
            </div>
        </div>
    );
};

export default ServiceDigitalMarketingSection;
