import React from 'react';
import { motion } from 'framer-motion';
import { Link } from 'react-router-dom';
import { COMPANY_NAME } from '../../utils/constants/company-details';

const TeamPreviewSection: React.FC = () => {
    // Sample team members - replace with your actual team data
    const teamMembers = [
        {
            id: 1,
            name: 'M Talha',
            position: 'Software Engineer (Full Stack)',
            image: '/images/team/team-1.jpg'
        },
        {
            id: 2,
            name: 'Sumbal Ilyas',
            position: 'SEO Specialist',
            image: '/images/team/team-2.jpg'
        },
        {
            id: 3,
            name: 'Umair Malik',
            position: 'Lead Developer',
            image: '/images/team/team-3.jpeg'
        },
        {
            id: 4,
            name: 'Sheryar Ahmed',
            position: 'Full Stack Web & App Developer',
            image: '/images/team/team-4.jpeg'
        },
    ];

    return (
        <section className="py-16 bg-gray-900">
            <div className="container px-4 mx-auto">
                <div className="text-center mb-12">
                    <motion.h2 
                        className="mb-4 text-3xl font-bold text-white md:text-4xl"
                        initial={{ opacity: 0, y: 20 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        viewport={{ once: true }}
                        transition={{ duration: 0.5 }}
                    >
                        Meet Our Team at {COMPANY_NAME}
                    </motion.h2>
                    <motion.p 
                        className="max-w-2xl mx-auto text-lg text-gray-300"
                        initial={{ opacity: 0, y: 20 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        viewport={{ once: true }}
                        transition={{ duration: 0.5, delay: 0.1 }}
                    >
                        Our team of experts is dedicated to delivering exceptional results for our clients.
                    </motion.p>
                </div>

                <div className="grid grid-cols-1 gap-8 mt-10 sm:grid-cols-2 lg:grid-cols-4">
                    {teamMembers.map((member, index) => (
                        <motion.div
                            key={member.id}
                            className="overflow-hidden bg-gray-800 rounded-lg shadow-lg"
                            initial={{ opacity: 0, y: 30 }}
                            whileInView={{ opacity: 1, y: 0 }}
                            viewport={{ once: true }}
                            transition={{ duration: 0.5, delay: 0.1 * index }}
                        >
                            <div className="overflow-hidden h-64">
                                <img 
                                    src={member.image} 
                                    alt={member.name}
                                    className="object-cover w-full h-full transition-transform duration-500 hover:scale-110"
                                />
                            </div>
                            <div className="p-6">
                                <h3 className="text-xl font-semibold text-white">{member.name}</h3>
                                <p className="text-gray-400">{member.position}</p>
                            </div>
                        </motion.div>
                    ))}
                </div>

                <motion.div 
                    className="mt-12 text-center"
                    initial={{ opacity: 0, y: 20 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    viewport={{ once: true }}
                    transition={{ duration: 0.5, delay: 0.2 }}
                >
                    <Link
                        to="/team"
                        className="inline-block px-8 py-3 text-lg font-medium text-white transition-colors duration-300 bg-blue-600 rounded-lg hover:bg-blue-700"
                    >
                        View Full Team
                    </Link>
                </motion.div>
            </div>
        </section>
    );
};

export default TeamPreviewSection;
